<?php
// /novademo/html/demo1/authentication/classic/login.php
declare(strict_types=1);
session_start();
require_once __DIR__ . '/../../config.php';

// ===== Error -> flash + cookie + hash param (SPA) =====
function fail(string $msg, int $code = 400): void {
  http_response_code($code);
  $_SESSION['auth_error'] = $msg;
  setcookie('auth_error', $msg, [
    'expires'  => time() + 120,
    'path'     => '/novademo',
    'secure'   => !empty($_SERVER['HTTPS']),
    'httponly' => true,
    'samesite' => 'Lax',
  ]);
  $hashMsg = rawurlencode($msg);
  header("Location: /novademo/html/demo1/index.php#login_error?m={$hashMsg}");
  exit;
}

function pdo_exec(PDO $pdo, string $sql, array $params, string $label) {
  preg_match_all('/:([a-zA-Z_][a-zA-Z0-9_]*)/', $sql, $m);
  $placeholders = array_unique($m[1] ?? []);
  $paramKeys = [];
  foreach ($params as $k => $_) { $paramKeys[] = ltrim((string)$k, ':'); }
  $paramKeys = array_unique($paramKeys);
  $missing = array_diff($placeholders, $paramKeys);
  $extra   = array_diff($paramKeys, $placeholders);
  if (!empty($missing) || !empty($extra)) {
    $msg = "{$label}: parameter mismatch.\n"
         . "SQL placeholders: [" . implode(', ', $placeholders) . "]\n"
         . "Given params:     [" . implode(', ', $paramKeys) . "]\n";
    if (!empty($missing)) $msg .= "Missing params: [" . implode(', ', $missing) . "]\n";
    if (!empty($extra))   $msg .= "Extra params:   [" . implode(', ', $extra) . "]\n";
    if (defined('NOVA_DEV') && NOVA_DEV === true) fail('DEV: ' . $msg, 500);
    fail('Unexpected server error. Please try again later.', 500);
  }
  $stmt = $pdo->prepare($sql);
  $norm = [];
  foreach ($params as $k => $v) {
    $norm[ (str_starts_with((string)$k, ':') ? $k : (':'.$k)) ] = $v;
  }
  $stmt->execute($norm);
  return $stmt;
}

// ===== POST only =====
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  header('Allow: POST');
  exit('Method Not Allowed');
}

// ===== Inputs =====
$email    = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$remember = isset($_POST['remember']);
if ($email === '' || $password === '') fail('Please enter both email and password.', 400);

try {
  $stmt = pdo_exec(
    $pdo,
    "SELECT id, email, password_hash, is_active FROM users WHERE email = :email LIMIT 1",
    ['email' => $email],
    'SELECT user'
  );
  $user = $stmt->fetch();
  $generic = 'Invalid email or password.';
  if (!$user) fail($generic, 401);
  if (!(int)$user['is_active']) fail('Your account is inactive. Please contact support.', 403);
  if (!password_verify($password, $user['password_hash'])) fail($generic, 401);

  if (password_needs_rehash($user['password_hash'], PASSWORD_DEFAULT)) {
    pdo_exec(
      $pdo,
      "UPDATE users
       SET password_hash = :h, updated_ip = :ip_updated, updated_at = NOW()
       WHERE id = :id",
      ['h' => password_hash($password, PASSWORD_DEFAULT),
       'ip_updated' => client_ip(),
       'id' => (int)$user['id']],
      'UPDATE rehash'
    );
  }

  pdo_exec(
    $pdo,
    "UPDATE users
     SET last_login_at = NOW(),
         last_login_ip = :ip_login,
         updated_ip     = :ip_updated,
         updated_at     = NOW()
     WHERE id = :id",
    ['ip_login' => client_ip(),
     'ip_updated' => client_ip(),
     'id' => (int)$user['id']],
    'UPDATE last_login'
  );

  session_regenerate_id(true);
  $_SESSION['user_id'] = (int)$user['id'];
  $_SESSION['user_email'] = $user['email'];
  $_SESSION['is_authenticated'] = true;

  if ($remember) {
    setcookie('remember_me', '1', [
      'expires'  => time() + 60*60*24*7,
      'path'     => '/',
      'secure'   => !empty($_SERVER['HTTPS']),
      'httponly' => true,
      'samesite' => 'Lax',
    ]);
  }

  header('Location: /novademo/html/demo1/index.php#profile');
  exit;

} catch (Throwable $e) {
  if (defined('NOVA_DEV') && NOVA_DEV === true) fail('DEV: ' . ($e->getMessage() ?: get_class($e)), 500);
  fail('Unexpected server error. Please try again later.', 500);
}

?>