<?php
// logout.php
declare(strict_types=1);
session_start();

$https = !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off';

if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', [
        'expires'  => time() - 42000,
        'path'     => $p['path'] ?? '/',
        'domain'   => $p['domain'] ?? '',   // empty = current host
        'secure'   => $p['secure'] ?? $https,
        'httponly' => $p['httponly'] ?? true,
        'samesite' => 'Lax',
    ]);
}

setcookie('remember_me', '', [
    'expires'  => time() - 3600,
    'path'     => '/',        // adjust if your cookie was set on a subpath
    'secure'   => $https,
    'httponly' => true,
    'samesite' => 'Lax',
]);

setcookie('auth_error', '', [
    'expires'  => time() - 3600,
    'path'     => '/novademo',  // match the path you used when setting it
    'secure'   => $https,
    'httponly' => true,
    'samesite' => 'Lax',
]);

$_SESSION = [];
session_destroy();

header('Location: /novademo/html/demo1/index.php#login');
exit;

?>