<?php
// /novademo/html/demo1/authentication/classic/partials/login_error.php
session_start();

$flash = '';
if (!empty($_SESSION['auth_error'])) {
  $flash = $_SESSION['auth_error'];
  unset($_SESSION['auth_error']);
} elseif (!empty($_COOKIE['auth_error'])) {
  $flash = $_COOKIE['auth_error'];
  setcookie('auth_error', '', [
    'expires'  => time() - 3600,
    'path'     => '/novademo',
    'secure'   => !empty($_SERVER['HTTPS']),
    'httponly' => true,
    'samesite' => 'Lax',
  ]);
} elseif (!empty($_GET['m'])) {
  // Fallback from SPA forwarding (hash m -> query ?m=...)
  $flash = (string)$_GET['m'];
}

if ($flash === '') {
  $flash = 'Login failed';
}
?>
<!DOCTYPE html>
<html class="h-full" data-kt-theme="true" data-kt-theme-mode="light" dir="ltr" lang="en">
<head>
  <!-- From /authentication/classic/partials/ back to /novademo/html/demo1/ -->
  <base href="../../../">
  <meta charset="utf-8"/>
  <title>Sign In - Nova Chain Investments</title>
  <meta name="robots" content="follow, index"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
  <meta name="description" content="Sign in to Nova Chain Investments"/>
  <meta name="twitter:site" content="@keenthemes"/>
  <meta name="twitter:creator" content="@keenthemes"/>
  <meta name="twitter:card" content="summary_large_image"/>
  <meta name="twitter:title" content="Metronic - Tailwind CSS Sign In"/>
  <meta name="twitter:description" content="Sign in page using Tailwind CSS"/>
  <meta name="twitter:image" content="assets/media/app/og-image.png"/>
  <meta property="og:url" content="https://127.0.0.1:8001/metronic-tailwind-html/demo1/authentication/classic/sign-in"/>
  <meta property="og:locale" content="en_US"/>
  <meta property="og:type" content="website"/>
  <meta property="og:site_name" content="@keenthemes"/>
  <meta property="og:title" content="Metronic - Tailwind CSS Sign In"/>
  <meta property="og:description" content="Sign in page using Tailwind CSS"/>
  <meta property="og:image" content="assets/media/app/og-image.png"/>
  <link rel="apple-touch-icon" sizes="180x180" href="assets/media/app/apple-touch-icon.png"/>
  <link rel="icon" type="image/png" sizes="32x32" href="assets/media/app/favicon-32x32.png"/>
  <link rel="icon" type="image/png" sizes="16x16" href="assets/media/app/favicon-16x16.png"/>
  <link rel="shortcut icon" href="assets/media/app/favicon.ico"/>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet"/>
  <link href="assets/vendors/apexcharts/apexcharts.css" rel="stylesheet"/>
  <link href="assets/vendors/keenicons/styles.bundle.css" rel="stylesheet"/>
  <link href="assets/css/styles.css" rel="stylesheet"/>
</head>
<body class="antialiased flex h-full text-base text-foreground bg-background">
  <!-- Theme Mode (same as sign-in.php) -->
  <script>
    const defaultThemeMode='light';let themeMode;
    if(document.documentElement){
      if(localStorage.getItem('kt-theme')){themeMode=localStorage.getItem('kt-theme');}
      else if(document.documentElement.hasAttribute('data-kt-theme-mode')){themeMode=document.documentElement.getAttribute('data-kt-theme-mode');}
      else{themeMode=defaultThemeMode;}
      if(themeMode==='system'){themeMode=window.matchMedia('(prefers-color-scheme: dark)').matches?'dark':'light';}
      document.documentElement.classList.add(themeMode);
    }
  </script>

  <!-- Same centered card layout as sign-in.php (no background image) -->
  <main id="page-content" class="w-full flex justify-center py-12">
    <div class="kt-card max-w-[370px] w-full">
      <div class="kt-card-content flex flex-col gap-5 p-10">
        <div class="text-center">
          <h3 class="text-lg font-medium text-mono leading-none mb-2.5">Sign in error</h3>
          <p class="text-sm text-destructive-foreground">
            <?= htmlspecialchars($flash, ENT_QUOTES, 'UTF-8'); ?>
          </p>
        </div>
        <a class="kt-btn kt-btn-primary flex justify-center"
           href="/novademo/html/demo1/authentication/classic/sign-in.php"
           data-page="login">Back to Sign In</a>
      </div>
    </div>
  </main>
  <script src="assets/js/core.bundle.js"></script>
  <script src="assets/vendors/ktui/ktui.min.js"></script>
  <script src="assets/vendors/apexcharts/apexcharts.min.js"></script>
</body>
</html>