<?php
// /novademo/html/demo1/config.php
declare(strict_types=1);

const NOVA_DEV = true;

$DB_HOST = '127.0.0.1';
$DB_NAME = 'novachain';
$DB_USER = 'root';
$DB_PASS = '';
$DB_DSN  = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";

$options = [
  PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
  $pdo = new PDO($DB_DSN, $DB_USER, $DB_PASS, $options);
} catch (Throwable $e) {
  http_response_code(500);
  exit('Database connection error.');
}

function client_ip(): string {
  foreach (['HTTP_CF_CONNECTING_IP','HTTP_X_FORWARDED_FOR','HTTP_CLIENT_IP','REMOTE_ADDR'] as $k) {
    if (!empty($_SERVER[$k])) {
      $ip = is_string($_SERVER[$k]) ? explode(',', $_SERVER[$k])[0] : '';
      return trim($ip);
    }
  }
  return '0.0.0.0';
}
?>


<?php
$pdo = new PDO('mysql:host=localhost;dbname=novachain;charset=utf8mb4', 'root', '', [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  PDO::ATTR_EMULATE_PREPARES => false,
]);


define('APP_DEBUG', true);


define('USERS_TABLE', 'users');
