<!DOCTYPE html>
<html class="h-full" data-kt-theme="true" data-kt-theme-mode="light" dir="ltr" lang="en">
<head>
  <base href="../../">
  <meta charset="utf-8"/>
  <title>Contact Us - Nova Chain Investments</title>
  <meta name="robots" content="follow, index"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
  <meta name="description" content="Contact Nova Chain Investments"/>
  <link rel="apple-touch-icon" sizes="180x180" href="assets/media/app/apple-touch-icon.png"/>
  <link rel="icon" type="image/png" sizes="32x32" href="assets/media/app/favicon-32x32.png"/>
  <link rel="icon" type="image/png" sizes="16x16" href="assets/media/app/favicon-16x16.png"/>
  <link rel="shortcut icon" href="assets/media/app/favicon.ico"/>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet"/>
  <link href="assets/vendors/apexcharts/apexcharts.css" rel="stylesheet"/>
  <link href="assets/vendors/keenicons/styles.bundle.css" rel="stylesheet"/>
  <link href="assets/css/styles.css" rel="stylesheet"/>
</head>
<body class="antialiased flex h-full text-base text-foreground bg-background">
  <!-- Theme Mode -->
  <script>
    const defaultThemeMode='light';let themeMode;
    if(document.documentElement){
      if(localStorage.getItem('kt-theme')){themeMode=localStorage.getItem('kt-theme');}
      else if(document.documentElement.hasAttribute('data-kt-theme-mode')){themeMode=document.documentElement.getAttribute('data-kt-theme-mode');}
      else{themeMode=defaultThemeMode;}
      if(themeMode==='system'){themeMode=window.matchMedia('(prefers-color-scheme: dark)').matches?'dark':'light';}
      document.documentElement.classList.add(themeMode);
    }
  </script>

  <style>
    .page-bg{background-image:url('assets/media/images/2600x1200/bg-10.png');}
    .dark .page-bg{background-image:url('assets/media/images/2600x1200/bg-10-dark.png');}
  </style>

  <main id="page-content" class="flex items-center justify-center grow bg-center bg-no-repeat page-bg min-h-screen">
    <div class="kt-card max-w-[370px] w-full">
      <form id="contactForm" data-contact-form class="kt-card-content flex flex-col gap-5 p-10" method="post" action="/novademo/html/demo1/send_contact.php" autocomplete="off" novalidate>
        <!-- Honeypot (hidden) -->
        <input type="text" name="website" value="" class="hidden" tabindex="-1" autocomplete="off" aria-hidden="true"/>
        <div class="text-center mb-2.5">
          <h3 class="text-lg font-medium text-mono leading-none mb-2.5">Contact Us</h3>
          <p class="text-sm text-secondary-foreground">
            Have questions or need assistance? Send us a message and we'll get back to you shortly.
          </p>
        </div>

        <!-- Name -->
        <div class="flex flex-col gap-1">
          <label for="contact_name" class="kt-form-label font-normal text-mono">Your Name</label>
          <input id="contact_name" class="kt-input" name="name" type="text" placeholder="John Doe" required/>
        </div>

        <!-- Email -->
        <div class="flex flex-col gap-1">
          <label for="contact_email" class="kt-form-label font-normal text-mono">Email</label>
          <input id="contact_email" class="kt-input" name="email" type="email" placeholder="you@example.com" required/>
        </div>

        <!-- Message -->
        <div class="flex flex-col gap-1">
          <label for="contact_message" class="kt-form-label font-normal text-mono">Message</label>
          <textarea id="contact_message"
                    class="kt-input"
                    name="message"
                    rows="4"
                    placeholder="How can we help you?"
                    style="resize: none;"
                    required></textarea>
        </div>

        <!-- Consent -->
        <label class="kt-label">
          <input class="kt-checkbox kt-checkbox-sm" name="consent" type="checkbox" value="1"/>
          <span class="kt-checkbox-label">I agree to be contacted regarding my inquiry</span>
        </label>

        <!-- Submit -->
        <button type="submit"
                id="contact_submit_btn"
                class="kt-btn kt-btn-primary inline-flex justify-center"
                style="width:auto; align-self:flex-start; padding:0.6rem 1rem;">
          Send Message
        </button>
      </form>
    </div>
  </main>

  <script src="assets/js/core.bundle.js"></script>
  <script src="assets/vendors/ktui/ktui.min.js"></script>
  <script src="assets/vendors/apexcharts/apexcharts.min.js"></script>
</body>
</html>
